//===========================================================================
// InformEditCtrl.h : interface of the CInformEditCtrl class
//
// This is a rich edit control which displays syntax-styled Inform source.  
// The only interesting method at present is the painfully slow SetText() - 
// see "InformEditCtrl.cpp".  This is the least satisfactory part of the 
// collection. 
//===========================================================================

#if !defined(INFORMEDITCTRL_H)
#define INFORMEDITCTRL_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


//***************************************************************************
// Includes
//***************************************************************************

#include "InformStyler.h"


//***************************************************************************
// Definitions
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// CInformEditCtrl Definition
//
class CInformEditCtrl : public CRichEditCtrl
{
  public:
	CInformEditCtrl();

// Attributes
  public:

// Operations
  public:
	void	SetText(LPCSTR text);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInformEditCtrl)
	public:
	//}}AFX_VIRTUAL

// Implementation
  public:
	virtual ~CInformEditCtrl();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
  protected:
	//{{AFX_MSG(CInformEditCtrl)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Helper methods
  protected:
	static DWORD CALLBACK	StreamInCallback(DWORD dwCookie, LPBYTE pBuff, 
											 LONG cb, LONG FAR * pcb);
// Data
  protected:
	CDWordArray	m_Styles;
	CString		m_Facename;
	UINT		m_FontSize;
	int			m_LastLineCount;
	int			m_EditLine;

	CString		m_RTFHeaderText;
	CString		m_RTFStyles[NUM_SYNTAX_STYLES];
	static const LPCTSTR	s_RTFParText;
	static const LPCTSTR	s_RTFCloseText;
};


#endif //!defined(INFORMEDITCTRL_H)
