//===========================================================================
// InformStyle.h		Enumeration of the Inform Syntax Styles
//
// This enumerates the different elements to be found in Inform source.
// For efficiency, these may be assumed to be sequential starting from zero
// (and so usable as indices in an array), but their number and order should 
// not be assumed.
//
// GN called these "Syntax Colours", but I am using the term style since it 
// is slightly more general.
//
// The first ten styles are straight from GN's "How to syntax-colour Inform"
// document (see "Algorithm.txt").  NumberStyle and CodeNumberStyle are 
// additions that I find useful and which are handled in the Colour 
// refinement phase.  InvalidStyle is just an error marker.
//===========================================================================

#if !defined(INFORMSTYLE_H)
#define INFORMSTYLE_H


//***************************************************************************
// Definitions
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// InformStyle Definition
//
enum InformStyle
{
	ForegroundStyle,
	QuotedTextStyle,
	CommentStyle,
	DirectiveStyle,
	PropertyStyle,
	FunctionStyle,
	CodeStyle,
	CodeAlphaStyle,
	AssemblyStyle,
	EscapeStyle,

	NumberStyle,
	CodeNumberStyle,

	InvalidStyle	// This should never be used except as an error indicator
};

#define NUM_SYNTAX_STYLES	InvalidStyle


#endif //!defined(INFORMSTYLE_H)
