//===========================================================================
// InformViewer.cpp : Defines the class behaviors for the application.
//===========================================================================

#include "stdafx.h"
#include "InformViewer.h"

#include "InformStyleDlg.h"
#include "InformViewerDoc.h"
#include "InformViewerView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//***************************************************************************
// CInformViewerApp basics
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// The one and only CInformViewerApp object
//
CInformViewerApp theApp;



/////////////////////////////////////////////////////////////////////////////
// Construction
//
CInformViewerApp::CInformViewerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


/////////////////////////////////////////////////////////////////////////////
// CInformViewerApp initialization
//
// Load default style appearance (among other things).
// You might want to change the registry location.
//
BOOL CInformViewerApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("John G. Wood's Applications"));

	LoadStdProfileSettings(10);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CInformViewerDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CInformViewerView));
	AddDocTemplate(pDocTemplate);

	//Set up default syntax colours
	InformStyleRecordSet::GetMasterStyles().LoadDefaults();

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOWMAXIMIZED);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// ExitInstance()
//
// Save style appearance.
//
int CInformViewerApp::ExitInstance()
{
	InformStyleRecordSet::GetMasterStyles().SaveDefaults();
	return CWinApp::ExitInstance();
}


/////////////////////////////////////////////////////////////////////////////
// Message Map
//
BEGIN_MESSAGE_MAP(CInformViewerApp, CWinApp)
	//{{AFX_MSG_MAP(CInformViewerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_TOOLS_SYNTAX_STYLES, OnToolsSyntaxStyles)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()


//***************************************************************************
// CAboutDlg dialog used for App About
//***************************************************************************

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CInformViewerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


//***************************************************************************
// CInformViewerApp commands
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// OnFileOpen()
//
// This is only overridden to set the open dialog properties.
// Adapted from Rich Lawrence's WinFrotz code, because I'm lazy.
//
void CInformViewerApp::OnFileOpen()
{
	CFileDialog	dlg( TRUE, ".inf", NULL,
		OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|OFN_READONLY, 
		"Inform Files (*.inf;*.h)|*.inf; *.h|All Files (*.*)|*.*||", NULL );
	if( dlg.DoModal()==IDOK )
	{
		CString name = dlg.GetPathName();
		OpenDocumentFile(name);
	}
}


/////////////////////////////////////////////////////////////////////////////
// OnToolsSyntaxStyles()
//
// Display the syntax styles dialog; if necessary update all open views 
// afterwards (which will take just as long as the first time).  This code 
// should work for MDI or SDI apps.
//
void CInformViewerApp::OnToolsSyntaxStyles()
{
	CInformStyleDlg dlg(InformStyleRecordSet::GetMasterStyles());
	if ( IDOK == dlg.DoModal() )
	{
		m_pMainWnd->UpdateWindow();	// So the dialog doesn't hang about...
		POSITION templPos = GetFirstDocTemplatePosition();
		while ( templPos )
		{
			CDocTemplate * templ = GetNextDocTemplate(templPos);
			ASSERT(templ);
			POSITION docPos = templ->GetFirstDocPosition();
			while ( docPos)
			{
				CDocument * doc = templ->GetNextDoc(docPos);
				ASSERT(doc);
				doc->UpdateAllViews(NULL);
			}
		}
	}
}


