/*=========================================================================*\
|* BaseSymbols.h
\*=========================================================================*/

#ifndef BASESYMBOLS_H
#define BASESYMBOLS_H

/*///////////////////////////////////////////////////////////////////////////
// Enumeration of masks for base symbols.
// This including "bases" from the comment field, like exile & prison camps.
//
// If there should be more than 9 of these on one map only the first nine
// will be put into the key, so the order is important.
*/
typedef enum
{
	ImperialNavalBase =			(1<< 0),
	ImperialScoutBase =			(1<< 1),
	ImperialNavalDepot =		(1<< 2),
	ImperialWayStation =		(1<< 3),

	IndependentNavalBase =		(1<< 4),
	NonImperialMilitaryBase =	(1<< 5),

	TlaukhuBase =				(1<< 6),
	AslanClanBase  =			(1<< 7),

	VargrNavalBase =			(1<< 8),
	VargrCorsairBase =			(1<< 9),

	DroyneNavalBase =			(1<<10),
	DroyneGarrison =			(1<<11),

	HiverNavalBase =			(1<<12),
	HiverEmbassyCentre =		(1<<13),
	HiverTemporaryBase =		(1<<14),
	HiverStagingBase =			(1<<15),

	KKreeNavalBase =			(1<<16),
	KKreeNavalOutpost =			(1<<17),

	InterfaceWorld =			(1<<18),
	TerminusWorld =				(1<<19),

	ZhodaniNavalBase =			(1<<20),
	ZhodaniRelayStation =		(1<<21),
	ZhodaniNavalDepot =			(1<<22),

	ExileCamp =					(1<<23),
	PrisonCamp =				(1<<24),
	ResearchStation =			(1<<25),
	Reserve =					(1<<26)
} BaseSymbol;


#endif	/* BASESYMBOLS_H */

