/*=========================================================================*\
|* FileIO.c
\*=========================================================================*/

#include "Gal2CC.h"

static const char * outputDir = NULL;


/***************************************************************************\
* CheckFileExists()
*
*/
BOOL CheckFileExists(const char * fileName)
{
	FILE * file;
	if ( NULL == fileName )
		return FALSE;
	file = fopen(fileName, "rt");
	if ( NULL == file )
		return FALSE;
	fclose(file);
	return TRUE;
}


/***************************************************************************\
* SetOutputDir()
*
*/
void SetOutputDir(const char * dir)
{
	outputDir = dir;
}


/***************************************************************************\
* OpenInputFile()
*
*/
char * OpenInputFile(const char * fileName)
{
	FILE * file;
	char * fileData;
	size_t fileSize;

	if ( NULL == fileName )
		return NULL;

	file = fopen(fileName, "rt");
	if ( !file )
	{
		ReportError("Couldn't open file <%s>!\n", fileName);
		return NULL;
	}
	if ( fseek(file, 0, SEEK_END) )
	{
		ReportError("Error reading file <%s>!\n", fileName);
		fclose(file);
		return NULL;
	}
	fileSize = ftell(file);
	if ( 0 >= fileSize )
	{
		ReportError("File <%s> invalid!\n", fileName);
		fclose(file);
		return NULL;
	}

	fileData = Allocate(fileSize);
	if ( NULL == fileData )
	{
		ReportError("Out of memory reading <%s>!\n", fileName);
		fclose(file);
		return NULL;
	}

	rewind(file);
	fileSize = fread(fileData, sizeof(char), fileSize, file);
	if ( 0 > fileSize )
	{
		ReportError("Error reading file <%s>!\n", fileName);
		Release(fileData);
		fclose(file);
		return NULL;
	}
	else
		fileData[fileSize] = '\0';

	fclose(file);
	return fileData;
}


/***************************************************************************\
* CloseInputFile()
*
*/
void CloseInputFile(char * fileData)
{
	Release(fileData);
}


/***************************************************************************\
* OpenOutputFile()
*
*/
BOOL OpenOutputFile(const char * givenFileName, FileRecord * output)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char fileName[_MAX_PATH];
	char backupFileName[_MAX_PATH];

	if ( NULL == givenFileName || NULL == output )
		return FALSE;

	if ( outputDir && strlen(outputDir) )
	{
		_splitpath(givenFileName, NULL, NULL, fname, ext );
		strcpy(fileName, outputDir);
		if ( '\\' != fileName[strlen(fileName)-1] )
			strcat(fileName, "\\");
		_splitpath(fileName, drive, dir, NULL, NULL );
		_makepath(fileName, drive, dir, fname, ext );
	}
	else
	{
		_splitpath(givenFileName, drive, dir, fname, ext );
		_makepath(fileName, drive, dir, fname, ext );
	}

	output->name = Allocate(strlen(fileName)+1);
	if ( NULL == output->name )
	{
		ReportError("Out of memory preparing to write <%s>!\n", fileName);
		return FALSE;
	}
	strcpy(output->name, fileName);

	output->file = fopen(fileName, "rt");
	if ( NULL != output->file )
	{
		fclose(output->file);
		_makepath(backupFileName, drive, dir, fname, "$$$" );
		if ( ( -1 == remove(backupFileName) && ENOENT != errno ) ||
			 ( 0 != rename(fileName, backupFileName) ) )
		{
			ReportWriteError(*output, "Error backing up file <%s>!\n");
			Release(output->name);
			output->name = NULL;
			return FALSE;
		}
	}
	output->file = fopen(fileName, "wt");
	if ( NULL == output->file )
	{
		ReportWriteError(*output, "Error creating file <%s>!\n");
		Release(output->name);
		output->name = NULL;
		return FALSE;
	}
	return TRUE;
}


/***************************************************************************\
* CloseOutputFile()
*
*/
void CloseOutputFile(FileRecord output)
{
	if ( NULL != output.file )
	{
		fclose(output.file);
		output.file = NULL;
	}
	if ( NULL != output.name )
	{
		Release(output.name);
		output.name = NULL;
	}
}


