/*=========================================================================*\
|* Line.c
\*=========================================================================*/

#include "Gal2CC.h"


/***************************************************************************\
* LineLength()
*
*/
int LineLength(const char * text)
{
	const char * eol;
	if ( NULL == text )
		return -1;
	eol = strchr(text, '\n');
	return eol ? (int)(eol-text) : strlen(text);
}


/***************************************************************************\
* NextLine()
*
*/
BOOL NextLine(char ** text)
{
	if ( NULL == text || NULL == *text )
		return FALSE;
	*text = strchr(*text, '\n');
	if ( NULL != *text )
	{
		++*text;
		return '\0' != **text;
	}
	else
		return FALSE;
}


/***************************************************************************\
* StripTrailingWhitespace()
*
*/
void StripTrailingWhitespace(char * text)
{
	char * end;
	if ( NULL == text )
		return;
	end = &text[strlen(text)-1];
	while ( end >= text && isspace(*end) )
		end--;
	end[1] = '\0';
}


/***************************************************************************\
* NewTextCopy()
*
*/
char * NewTextCopy(const char * sourceText)
{
	char * text;
	if ( NULL == sourceText )
		return NULL;
	text = Allocate(strlen(sourceText)+1);
	if ( text )
		strcpy(text, sourceText);
	return text;
}


/***************************************************************************\
* DeleteTextCopy()
*
*/
void DeleteTextCopy(char * text)
{
	Release(text);
}
